/*
 * Decompiled with CFR 0.152.
 */
package entities.creatures;

import core.Sprite;
import core.states.GameState;
import entities.creatures.CreatureEntity;
import util.ResourceManager;

public abstract class PlayerCreatureEntity
extends CreatureEntity {
    protected Sprite passiveIcon;
    protected Sprite abilityQIcon;
    protected Sprite abilityWIcon;
    protected Sprite abilityEIcon;
    protected Sprite abilityRIcon;
    protected Sprite abilityDIcon;
    protected Sprite abilityFIcon;
    protected Sprite passiveIconActive;
    protected Sprite abilityQIconActive;
    protected Sprite abilityWIconActive;
    protected Sprite abilityEIconActive;
    protected Sprite abilityRIconActive;
    protected Sprite abilityDIconActive;
    protected Sprite abilityFIconActive;
    protected Sprite passiveIconPassive;
    protected Sprite abilityQIconPassive;
    protected Sprite abilityWIconPassive;
    protected Sprite abilityEIconPassive;
    protected Sprite abilityRIconPassive;
    protected Sprite abilityDIconPassive;
    protected Sprite abilityFIconPassive;
    protected int abilityDCooldown = 0;
    protected int abilityFCooldown = 0;
    protected long lastAbilityDTime;
    protected long lastAbilityFTime;

    public PlayerCreatureEntity(GameState game, String sprite, int x, int y) {
        super(game, sprite, x, y);
    }

    @Override
    protected void set() {
        super.set();
        this.lastAbilityFTime = 0L;
        this.lastAbilityDTime = 0L;
    }

    public void resetPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void useAbilityD() {
        if (this.isAbilityDOnCooldown()) {
            return;
        }
        this.lastAbilityDTime = this.game.getTime();
        this.abilityD();
    }

    public void useAbilityF() {
        if (this.isAbilityFOnCooldown()) {
            return;
        }
        this.lastAbilityFTime = this.game.getTime();
        this.abilityF();
    }

    protected abstract void abilityD();

    protected abstract void abilityF();

    public long getAbilityDCooldown() {
        return Math.max(this.lastAbilityDTime + (long)this.abilityDCooldown - this.game.getTime(), 0L);
    }

    public long getAbilityFCooldown() {
        return Math.max(this.lastAbilityFTime + (long)this.abilityFCooldown - this.game.getTime(), 0L);
    }

    public boolean isAbilityDOnCooldown() {
        return this.getAbilityDCooldown() > 0L;
    }

    public boolean isAbilityFOnCooldown() {
        return this.getAbilityFCooldown() > 0L;
    }

    @Override
    public void draw() {
        super.draw();
        this.drawHealthbar(0, (int)(ResourceManager.get().getDimension().getHeight() - (double)this.entityIcon.getHeight()));
    }

    public abstract void drawPauseMenuInfo();

    public abstract void drawIcons();
}

